/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSOperation;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class WSPortType {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSPortType";
    private WSDefinition m_definition = null;
    private PortType m_portType = null;
    private WSOperation[] m_operations = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:03:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_portType = null;
                if (this.m_operations != null) {
                    WSOperation[] operations = this.m_operations;
                    this.m_operations = null;
                    WSOperation operation = null;
                    for (int i = 0; i < operations.length; ++i) {
                        if (operations[i] == null) continue;
                        operation = operations[i];
                        operations[i] = null;
                        operation.releaseReferences();
                        operation = null;
                    }
                    operations = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSPortType(WSDefinition definition, PortType portType) {
        List l;
        this.m_definition = definition;
        this.m_portType = portType;
        if (portType != null && (l = portType.getOperations()) != null && l.size() > 0) {
            this.m_operations = new WSOperation[l.size()];
            Iterator it = l.iterator();
            if (it != null) {
                int i = 0;
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null || !(obj instanceof Operation)) continue;
                    this.m_operations[i++] = new WSOperation(this.m_definition, this, (Operation)obj);
                }
            }
        }
    }

    public PortType getPortType() {
        return this.m_portType;
    }

    public QName getQName() {
        if (this.m_portType != null) {
            return this.m_portType.getQName();
        }
        return null;
    }

    public String getName() {
        if (this.m_portType != null) {
            return this.m_portType.getQName().getLocalPart();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_portType != null) {
            return this.m_portType.getQName().getLocalPart();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public WSOperation[] getOperations() {
        return this.m_operations;
    }

    public WSOperation getOperation(String operationName, String inputName, String outputName) {
        if (this.m_operations != null && operationName != null) {
            if (inputName != null && inputName.trim().length() == 0) {
                inputName = null;
            }
            if (outputName != null && outputName.trim().length() == 0) {
                outputName = null;
            }
            if (this.m_operations.length == 1 && inputName == null && outputName == null) {
                return this.m_operations[0];
            }
            for (int i = 0; i < this.m_operations.length; ++i) {
                if (this.m_operations[i] == null) continue;
                String opName = this.m_operations[i].getName();
                String inName = this.m_operations[i].getInputName();
                String outName = this.m_operations[i].getOutputName();
                if (inName != null && inName.trim().length() == 0) {
                    inName = null;
                }
                if (outName != null && outName.trim().length() == 0) {
                    outName = null;
                }
                if (opName == null || opName.compareTo(operationName) != 0 || (inputName != null || inName != null) && (inputName == null || inName == null || inputName.compareTo(inName) != 0) || (outputName != null || outName != null) && (outputName == null || outName == null || outputName.compareTo(outName) != 0)) continue;
                return this.m_operations[i];
            }
        }
        if (inputName == null && outputName == null) {
            return this.getOperation(operationName);
        }
        return null;
    }

    public WSOperation[] getOperations(String operationName) {
        if (this.m_operations != null && operationName != null) {
            Vector<WSOperation> v = new Vector<WSOperation>();
            for (int i = 0; i < this.m_operations.length; ++i) {
                String opName;
                if (this.m_operations[i] == null || (opName = this.m_operations[i].getName()) == null || opName.compareTo(operationName) != 0) continue;
                v.add(this.m_operations[i]);
            }
            if (v != null && v.size() > 0) {
                WSOperation[] operations = new WSOperation[v.size()];
                v.toArray(operations);
                v.clear();
                return operations;
            }
        }
        return null;
    }

    public WSOperation getOperation(String operationName) {
        if (this.m_operations != null && operationName != null) {
            for (int i = 0; i < this.m_operations.length; ++i) {
                String opName;
                if (this.m_operations[i] == null || (opName = this.m_operations[i].getName()) == null || opName.compareTo(operationName) != 0) continue;
                return this.m_operations[i];
            }
        }
        return null;
    }
}

